
from gurobipy import *

# Create a new model
m = Model("Steel_Shop_Profit")

# Define the decision variables
F = m.addVar(name="Number_of_Fences", vtype=GRB.INTEGER, lb=0)
D = m.addVar(name="Number_of_Doors", vtype=GRB.INTEGER, lb=0)

# Define the objective function: Maximize profit
m.setObjective(200*F + 100*D, GRB.MAXIMIZE)

# Add constraints based on material availability
m.addConstr(2*F + 5*D <= 400, name="Stainless_Steel_Constraint")
m.addConstr(10*F + D <= 500, name="Aluminum_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {F.varName} = {F.x}, {D.varName} = {D.x}")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found")
