
import gurobi

def solve_steel_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    F = model.addVar(lb=0, name="Fences")
    D = model.addVar(lb=0, name="Doors")

    # Objective function: Maximize profit
    model.setObjective(200 * F + 100 * D, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2 * F + 5 * D <= 400, name="StainlessSteel")
    model.addConstr(10 * F + D <= 500, name="Aluminum")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Fences = {F.varValue}, Doors = {D.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_steel_shop_problem()
