
import gurobipy as gp

# Create a new model
model = gp.Model("Printing_Optimization")

# Create variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="books")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magazines")

# Set objective function
model.setObjective(5 * x + 8 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10 * x + 20 * y <= 5000, "printing_time")
model.addConstr(5 * x + 3 * y <= 2000, "binding_time")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of books to print: {x.x}")
    print(f"Number of magazines to print: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

