
from gurobipy import *

# Create a new model
m = Model("Printing_Company_Profit_Maximization")

# Define the decision variables
B = m.addVar(vtype=GRB.CONTINUOUS, name="Number_of_Books", lb=0)
M = m.addVar(vtype=GRB.CONTINUOUS, name="Number_of_Magazines", lb=0)

# Set the objective function to maximize profit
m.setObjective(5*B + 8*M, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*B + 20*M <= 5000, "Printing_Time_Constraint")
m.addConstr(5*B + 3*M <= 2000, "Binding_Time_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Books: {B.x}")
    print(f"Number of Magazines: {M.x}")
    print(f"Maximum Profit: ${5*B.x + 8*M.x:.2f}")
else:
    print("No optimal solution found")
