
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
B = m.addVar(lb=0, name="Books")
M = m.addVar(lb=0, name="Magazines")

# Define the objective function
m.setObjective(5*B + 8*M, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(10*B + 20*M <= 5000, name="Printing_Time")
m.addConstr(5*B + 3*M <= 2000, name="Binding_Time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of books to print: {B.varValue}")
    print(f"Number of magazines to print: {M.varValue}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
