
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("BerryMix")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x") # Bags of mix A
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="y") # Bags of mix B

# Set objective function
m.setObjective(5*x + 3*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(30*x + 20*y >= 150, "BlueberryConstraint")
m.addConstr(45*x + 15*y >= 125, "BlackberryConstraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Number of bags of mix A: {x.x}")
    print(f"  Number of bags of mix B: {y.x}")
    print(f"  Minimum cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

