
from gurobipy import *

# Create a new model
m = Model("Berry_Mix_Optimization")

# Define the decision variables
x_A = m.addVar(name="berry_mix_A", vtype=GRB.CONTINUOUS, lb=0)
x_B = m.addVar(name="berry_mix_B", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function: minimize the total cost
m.setObjective(5*x_A + 3*x_B, GRB.MINIMIZE)

# Add constraints for blueberries and blackberries
m.addConstr(30*x_A + 20*x_B >= 150, name="blueberry_constraint")
m.addConstr(45*x_A + 15*x_B >= 125, name="blackberry_constraint")

# Optimize the model
m.optimize()

# Check if an optimal solution was found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Purchase {x_A.x} bags of berry mix A")
    print(f"Purchase {x_B.x} bags of berry mix B")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")

