
import gurobi

def solve_berry_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="berry_mix_A", lb=0)  # Number of bags of berry mix A
    y = model.addVar(name="berry_mix_B", lb=0)  # Number of bags of berry mix B

    # Objective function: minimize cost
    model.setObjective(5 * x + 3 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(30 * x + 20 * y >= 150, name="blueberry_constraint")
    model.addConstr(45 * x + 15 * y >= 125, name="blackberry_constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: {model.objVal}")
        print(f"Bags of berry mix A: {x.varValue}")
        print(f"Bags of berry mix B: {y.varValue}")
    else:
        print("No optimal solution found")

# Run the function
solve_berry_mix_problem()
