
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fish_processing")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="small_fish") # Number of small fish
y = m.addVar(vtype=GRB.INTEGER, name="large_fish") # Number of large fish

# Set objective function
m.setObjective(8*x + 11*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 10*y <= 500, "cleaning_time")
m.addConstr(10*x + 15*y <= 700, "cutting_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small fish to process (x): {x.x}")
    print(f"Number of large fish to process (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

