
from gurobipy import *

# Create a new model
m = Model("Fish_Cleaning_and_Cutting")

# Define the decision variables
x_s = m.addVar(vtype=GRB.CONTINUOUS, name="small_fish")
x_l = m.addVar(vtype=GRB.CONTINUOUS, name="large_fish")

# Set the objective function
m.setObjective(8*x_s + 11*x_l, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x_s + 10*x_l <= 500, "cleaning_time")
m.addConstr(10*x_s + 15*x_l <= 700, "cutting_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of small fish: {x_s.x}")
    print(f"Number of large fish: {x_l.x}")
    print(f"Maximum profit: ${8*x_s.x + 11*x_l.x:.2f}")
else:
    print("No optimal solution found.")
