
import gurobi

def solve_fish_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    S = model.addVar(lb=0, name="Small Fish")
    L = model.addVar(lb=0, name="Large Fish")

    # Define the objective function
    model.setObjective(8 * S + 11 * L, gurobi.GRB.MAXIMIZE)

    # Add cleaning time constraint
    model.addConstr(5 * S + 10 * L <= 500, name="Cleaning Time")

    # Add cutting time constraint
    model.addConstr(10 * S + 15 * L <= 700, name="Cutting Time")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Small Fish: {S.varValue}, Large Fish: {L.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

# Run the function
solve_fish_problem()
