
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("CaMilk_Production")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="muffins") # Number of muffins
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="milk_cakes") # Number of milk cakes

# Set objective function
m.setObjective(6.5 * x + 8.5 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * x + 100 * y <= 25000, "milk_availability")
m.addConstr(y >= 2 * x, "demand_relationship")
m.addConstr(x >= 50, "min_muffins")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of muffins to produce: {x.x}")
    print(f"Number of milk cakes to produce: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

