
from gurobipy import *

# Create a new model
m = Model("CaMilk_Optimization")

# Define variables
M = m.addVar(lb=0, vtype=GRB.INTEGER, name="Muffins")
C = m.addVar(lb=0, vtype=GRB.INTEGER, name="Milk_Cakes")

# Objective function: Maximize profit
m.setObjective(6.5*M + 8.5*C, GRB.MAXIMIZE)

# Constraints
m.addConstr(15*M + 100*C <= 25000, "Milk_Availability")
m.addConstr(C >= 2*M, "Milk_Cakes_vs_Muffins")
m.addConstr(M >= 50, "Minimum_Muffins")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Muffins: {M.x}")
    print(f"Milk Cakes: {C.x}")
    print(f"Maximum Profit: ${6.5*M.x + 8.5*C.x:.2f}")
else:
    print("No optimal solution found")
