
import gurobi

def solve_camilk_problem():
    # Create a new model
    model = gurobi.Model()

    # Variables
    x = model.addVar(lb=0, name="muffins")
    y = model.addVar(lb=0, name="milk_cakes")

    # Objective function
    model.setObjective(6.5 * x + 8.5 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15 * x + 100 * y <= 25000, name="milk_constraint")
    model.addConstr(y >= 2 * x, name="ratio_constraint")
    model.addConstr(x >= 50, name="min_muffins_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: muffins = {x.varValue}, milk cakes = {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_camilk_problem()
