
import gurobipy as gp

# Create a new model
model = gp.Model("diet_problem")

# Create variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="soup")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sandwiches")

# Set objective function
model.setObjective(1*x + 3*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(200*x + 250*y >= 2000, "calories")
model.addConstr(5*x + 10*y >= 100, "protein")
model.addConstr(4*x + 15*y >= 100, "carbs")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Cans of soup: {x.x:.2f}")
    print(f"Sandwiches: {y.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

