
from gurobipy import *

# Create a model
m = Model("Labor_Camp_Diet")

# Define decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="cans_of_soup")
y = m.addVar(vtype=GRB.CONTINUOUS, name="sandwiches")

# Objective function: minimize total cost
m.setObjective(1*x + 3*y, GRB.MINIMIZE)

# Constraints
m.addConstr(200*x + 250*y >= 2000, "calories_constraint")
m.addConstr(5*x + 10*y >= 100, "protein_constraint")
m.addConstr(4*x + 15*y >= 100, "carbs_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Minimum cost diet:")
    print(f"Cans of soup: {x.x}")
    print(f"Sandwiches: {y.x}")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
