
import gurobi

def min_cost_diet():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    S = m.addVar(name="soup", lb=0, ub=gurobi.GRB.INFINITY)
    D = m.addVar(name="sandwich", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective: minimize cost
    m.setObjective(S + 3 * D, gurobi.GRB.MINIMIZE)

    # Constraints
    m.addConstr(200 * S + 250 * D >= 2000, name="calories")
    m.addConstr(5 * S + 10 * D >= 100, name="protein")
    m.addConstr(4 * S + 15 * D >= 100, name="carbs")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: {m.objVal}")
        print(f"Soup: {S.varValue}, Sandwich: {D.varValue}")
    else:
        print("No optimal solution found")

if __name__ == "__main__":
    min_cost_diet()
