
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("GrusCreation_Staffing")

# Create decision variables
r = model.addVar(vtype=GRB.INTEGER, name="researchers")
d = model.addVar(vtype=GRB.INTEGER, name="developers")

# Set objective function
model.setObjective(2500*r + 1500*d, GRB.MINIMIZE)

# Add constraints
model.addConstr(r + d >= 50, "total_workers")
model.addConstr(d >= 30, "min_developers")
model.addConstr(r >= (1/3)*d, "researcher_ratio")
model.addConstr(2500*r + 1500*d <= 250000, "max_payroll")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Researchers: {r.x}")
    print(f"Number of Developers: {d.x}")
    print(f"Total Weekly Wages: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

