
from gurobipy import *

# Create a new model
m = Model("GrusCreation_Optimization")

# Define variables
R = m.addVar(vtype=GRB.CONTINUOUS, name="Researchers")
D = m.addVar(vtype=GRB.CONTINUOUS, name="Developers")

# Set objective function: Minimize total wages
m.setObjective(2500*R + 1500*D, GRB.MINIMIZE)

# Add constraints
m.addConstr(R + D >= 50, "Total_workers")
m.addConstr(D >= 30, "Minimum_developers")
m.addConstr(R >= (1/3)*D, "Researchers_vs_Developers")
m.addConstr(2500*R + 1500*D <= 250000, "Payroll_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Researchers: {R.x}")
    print(f"Number of Developers: {D.x}")
    print(f"Total wages: ${2500*R.x + 1500*D.x:.2f}")
else:
    print("No optimal solution found")
