
import gurobi as gp

# Create a new model
m = gp.Model("GrusCreation_Workforce_Optimization")

# Define variables
R = m.addVar(name="Researchers", lb=0, vtype=gp.GRB.INTEGER)  # Number of researchers
D = m.addVar(name="Developers", lb=0, vtype=gp.GRB.INTEGER)  # Number of developers

# Objective: Minimize the total weekly payroll
m.setObjective(2500*R + 1500*D, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(R + D >= 50, name="Total_Workforce")  # At least 50 workers
m.addConstr(D >= 30, name="Developers_Requirement")  # At least 30 developers
m.addConstr(R >= D/3, name="Researchers_to_Developers_Ratio")  # Researchers at least 1/3 of developers
m.addConstr(2500*R + 1500*D <= 250000, name="Payroll_Limit")  # Payroll limit

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Researchers = {R.varValue}, Developers = {D.varValue}")
    print(f"Minimum Payroll: ${2500*R.varValue + 1500*D.varValue}")
else:
    print("No optimal solution found")
