
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("battery_optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="x") # AA batteries
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="y") # D batteries

# Set objective function
model.setObjective(0.5 * x + 1 * y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(1 * x + 3 * y <= 1000, "budget_constraint")
model.addConstr(x + y <= 1000, "demand_constraint")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of AA batteries (x): {x.x}")
    print(f"Number of D batteries (y): {y.x}")
    print(f"Maximum Profit: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

