
from gurobipy import *

# Create a new model
m = Model("Battery_Profit_Optimization")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="AA_Batteries")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="D_Batteries")

# Set the objective function: Maximize profit
m.setObjective(0.50*x + 1*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + 3*y <= 1000, "Budget_Constraint")
m.addConstr(x <= 1000, "Demand_AA_Batteries")
m.addConstr(y <= 1000, "Demand_D_Batteries")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("The model is infeasible")
