
import gurobipy as gp

# Create a new model
model = gp.Model("Battery_Stocking")

# Define variables
x = model.addVar(name="AA_Batteries", lb=0, ub=1000, vtype=gp.GRB.INTEGER)
y = model.addVar(name="D_Batteries", lb=0, ub=1000, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(0.50 * x + 1 * y, gp.GRB.MAXIMIZE)

# Budget constraint
model.addConstr(x + 3 * y <= 1000, name="Budget_Constraint")

# Demand constraint
model.addConstr(x + y <= 1000, name="Demand_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: AA Batteries = {x.varValue}, D Batteries = {y.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible")
