
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("lisa_investment")

    # Create variables
    x = m.addVar(name="nft_investment")  # Investment in NFTs
    y = m.addVar(name="crypto_investment") # Investment in cryptocurrency

    # Set objective function
    m.setObjective(0.30 * x + 0.40 * y, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 5000, "total_investment")
    m.addConstr(x >= 0.25 * (x + y), "min_nft_investment")
    m.addConstr(y >= 2300, "min_crypto_investment")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal investment in NFTs: ${x.x:.2f}")
        print(f"Optimal investment in cryptocurrency: ${y.x:.2f}")
        print(f"Maximum profit: ${m.objVal:.2f}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")

except gp.GrorbiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

