
from gurobipy import *

# Create a new model
m = Model("Lisa_Investment")

# Define decision variables
x_NFT = m.addVar(name='x_NFT', lb=0)  # Amount invested in NFTs
x_crypto = m.addVar(name='x_crypto', lb=0)  # Amount invested in crypto-currency

# Objective function: Maximize profit
m.setObjective(0.30*x_NFT + 0.40*x_crypto, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_NFT + x_crypto <= 5000, name='Total_Investment')  # Total investment limit
m.addConstr(x_NFT >= 0.25*(x_NFT + x_crypto), name='NFT_Min_Percent')  # Minimum NFT percentage
m.addConstr(x_crypto >= 2300, name='Crypto_Min_Investment')  # Minimum crypto-currency investment

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Invest in NFTs: ${x_NFT.x:.2f}')
    print(f'Invest in Crypto-Currency: ${x_crypto.x:.2f}')
    print(f'Total Profit: ${m.objVal:.2f}')
else:
    print('No optimal solution found')
