
import gurobi

def lisa_investment_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x1 = m.addVar(name="NFTs", lb=0)  # Investment in NFTs
    x2 = m.addVar(name="crypto-currency", lb=0)  # Investment in crypto-currency

    # Objective function: Maximize profit
    m.setObjective(0.30 * x1 + 0.40 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(x1 + x2 <= 5000, name="total_investment_limit")
    m.addConstr(3 * x1 >= x2, name="min_NFTs_percentage")
    m.addConstr(x2 >= 2300, name="min_crypto_investment")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal profit: ", m.objVal)
        print("Investment in NFTs: ", x1.varValue)
        print("Investment in crypto-currency: ", x2.varValue)
    else:
        print("The problem is infeasible")

lisa_investment_problem()
