
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("console_production")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="premium_consoles") # Integer since you can't make fractions of consoles.
y = m.addVar(vtype=GRB.INTEGER, name="regular_consoles")

# Set objective
m.setObjective(100*x + 75*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 10*y <= 10000, "testing_time")
m.addConstr(3*x + 2*y <= 1500, "ic_chips")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Premium consoles: {x.x}")
    print(f"Regular consoles: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

