
from gurobipy import *

# Create a model
m = Model("ConsoleProduction")

# Define decision variables
P = m.addVar(vtype=GRB.CONTINUOUS, name="PremiumConsoles", lb=0)
R = m.addVar(vtype=GRB.CONTINUOUS, name="RegularConsoles", lb=0)

# Objective function: Maximize profit
m.setObjective(100*P + 75*R, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*P + 10*R <= 10000, "TestingTime")
m.addConstr(3*P + 2*R <= 1500, "ICChips")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Premium Consoles: {P.x}")
    print(f"Regular Consoles: {R.x}")
    print(f"Maximum Profit: ${100*P.x + 75*R.x:.2f}")
else:
    print("No optimal solution found")
