
import gurobi as gp

# Create a new model
m = gp.Model("console_production")

# Define the decision variables
P = m.addVar(name="premium_consoles", lb=0, vtype=gp.GRB.INTEGER)
R = m.addVar(name="regular_consoles", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
m.setObjective(100 * P + 75 * R, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * P + 10 * R <= 10000, name="testing_time_constraint")
m.addConstr(3 * P + 2 * R <= 1500, name="ic_chip_constraint")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Premium consoles to produce: {P.varValue}")
    print(f"Regular consoles to produce: {R.varValue}")
    print(f"Maximum profit: ${100 * P.varValue + 75 * R.varValue}")
else:
    print("No optimal solution found.")
