
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("team_optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="small_teams") # Number of small teams (integer)
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="large_teams") # Number of large teams (integer)


# Set objective function: Minimize cost
m.setObjective(5000*x + 15000*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x + 20*y >= 100, "task_completion") # Task completion constraint
m.addConstr(x + 3*y <= 10, "supervisor_limit") # Supervisor limit constraint

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small teams (x): {x.x}")
    print(f"Number of large teams (y): {y.x}")
    print(f"Minimum Cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists that satisfies all constraints.")
else:
    print(f"Optimization terminated with status: {m.status}")

