
from gurobipy import *

# Create a new model
m = Model("Team_Optimization")

# Define the decision variables
x = m.addVar(name="small_teams", vtype=GRB.INTEGER, lb=0)
y = m.addVar(name="large_teams", vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(5000*x + 15000*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x + 20*y >= 100, name="task_requirement")
m.addConstr(x + 3*y <= 10, name="supervisor_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small teams: {x.x}")
    print(f"Large teams: {y.x}")
    print(f"Total cost: ${5000*x.x + 15000*y.x}")
else:
    print("No optimal solution found")
