
import gurobi

def solve_team_formation():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    S = m.addVar(vtype=gurobi.GRB.INTEGER, name="Small_Teams")
    L = m.addVar(vtype=gurobi.GRB.INTEGER, name="Large_Teams")

    # Objective function: Minimize cost
    m.setObjective(5000 * S + 15000 * L, gurobi.GRB.MINIMIZE)

    # Constraints
    m.addConstr(8 * S + 20 * L >= 100, name="Task_Requirement")
    m.addConstr(S + 3 * L <= 10, name="Supervisor_Limit")

    # Non-negativity constraints are inherently handled by defining variables as non-negative

    # Solve the model
    m.optimize()

    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Small Teams = {S.varValue}, Large Teams = {L.varValue}")
        print(f"Minimum Cost: ${m.objVal}")
    elif m.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("Failed to find an optimal solution.")

solve_team_formation()
