
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Optimization")

# Create decision variables
x = m.addVar(lb=0, name="solar_investment")
y = m.addVar(lb=0, name="wind_investment")

# Set objective function
m.setObjective(0.06 * x + 0.05 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50000, "total_investment")
m.addConstr(y >= 0.7 * 50000, "min_wind_investment")
m.addConstr(x <= 0.2 * 50000, "max_solar_investment")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in solar: ${x.x}")
    print(f"Optimal investment in wind: ${y.x}")
    print(f"Optimal total return: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

