
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define the decision variables
x_s = m.addVar(lb=0, name="solar_investment")
x_w = m.addVar(lb=0, name="wind_investment")

# Objective function: Maximize return
m.setObjective(0.06*x_s + 0.05*x_w, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_s + x_w == 50000, "total_investment")
m.addConstr(x_w >= 35000, "min_wind_investment")
m.addConstr(x_s <= 10000, "max_solar_investment")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Solar Investment: ${x_s.x:.2f}")
    print(f"Wind Investment: ${x_w.x:.2f}")
    print(f"Total Return: ${0.06*x_s.x + 0.05*x_w.x:.2f}")
else:
    print("No optimal solution found")
