
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_s = model.addVar(lb=0, name="Solar_Investment")  # Investment in solar energy
    x_w = model.addVar(lb=0, name="Wind_Investment")  # Investment in wind energy

    # Objective function: Maximize return
    model.setObjective(0.06 * x_s + 0.05 * x_w, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x_s + x_w <= 50000, name="Budget_Constraint")
    model.addConstr(x_w >= 0.70 * 50000, name="Wind_Constraint")
    model.addConstr(x_s <= 0.20 * 50000, name="Solar_Constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in solar energy: ${x_s.varValue}")
        print(f"Optimal investment in wind energy: ${x_w.varValue}")
        print(f"Maximal return: ${0.06 * x_s.varValue + 0.05 * x_w.varValue}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
