
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("jam_production")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="strawberry_jam")
y = m.addVar(vtype=GRB.INTEGER, name="peach_jam")

# Set objective function
m.setObjective(3*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 30*y <= 3500, "time_constraint")
m.addConstr(x <= 100, "strawberry_limit")
m.addConstr(y <= 80, "peach_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Produce {x.x} bottles of strawberry jam")
    print(f"Produce {y.x} bottles of peach jam")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

