
from gurobipy import *

# Create a new model
m = Model("Jam_Production")

# Define variables
x = m.addVar(lb=0, name="strawberry_jam")
y = m.addVar(lb=0, name="peach_jam")

# Define constraints
m.addConstr(20*x + 30*y <= 3500, name="time_constraint")
m.addConstr(x <= 100, name="strawberry_availability")
m.addConstr(y <= 80, name="peach_availability")

# Define the objective function
m.setObjective(3*x + 5*y, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
