
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, ub=100, name="strawberry_jam")
y = model.addVar(lb=0, ub=80, name="peach_jam")

# Set the objective function
model.setObjective(3*x + 5*y, gurobi.GRB.MAXIMIZE)

# Add the time constraint
model.addConstr(20*x + 30*y <= 3500, name="time_constraint")

# Add the fruit availability constraints
model.addConstr(x <= 100, name="strawberry_jam_constraint")
model.addConstr(y <= 80, name="peach_jam_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of bottles of strawberry jam: {x.varValue}")
    print(f"Number of bottles of peach jam: {y.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
