
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Fried_Food_Optimization")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="fish")  # Fish
y = model.addVar(vtype=GRB.CONTINUOUS, name="chicken") # Chicken

# Set objective function
model.setObjective(4*x + 5*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 4*y <= 400, "batter_constraint")
model.addConstr(5*x + 6*y <= 500, "oil_constraint")

# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal number of fish to sell: {x.x}")
    print(f"Optimal number of chicken to sell: {y.x}")
    print(f"Optimal revenue: ${model.objVal}")

