
from gurobipy import *

# Create a new model
model = Model("Fried_Fish_and_Chicken")

# Define variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="fried_fish")
y = model.addVar(vtype=GRB.CONTINUOUS, name="fried_chicken")

# Set the objective function to maximize revenue
model.setObjective(4*x + 5*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 4*y <= 400, "batter_constraint")
model.addConstr(5*x + 6*y <= 500, "oil_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum revenue: {4*x.x + 5*y.x}")
else:
    print("No optimal solution found")

