
import gurobi as gp

# Create a new model
model = gp.Model("street_vendor")

# Define the decision variables
x = model.addVar(lb=0, name="fried_fish")
y = model.addVar(lb=0, name="fried_chicken")

# Define the objective function
model.setObjective(4*x + 5*y, gp.GRB.MAXIMIZE)

# Add the batter constraint
model.addConstr(3*x + 4*y <= 400, name="batter_constraint")

# Add the oil constraint
model.addConstr(5*x + 6*y <= 500, name="oil_constraint")

# Optimize the model
model.optimize()

# Check if the model is optimized
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Fried Fish: {x.varValue}")
    print(f"Fried Chicken: {y.varValue}")
    print(f"Max Revenue: {model.objVal}")
else:
    print("The model is infeasible or has no solution.")
