
import gurobipy as gp

# Create a new model
model = gp.Model("SandwichOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tuna_sandwiches")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_sandwiches")

# Set objective function
model.setObjective(2*x + 3*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 5*y <= 300, "mixing_time")
model.addConstr(5*x + 6*y <= 400, "assembly_time")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of tuna sandwiches: {x.x}")
    print(f"Number of chicken sandwiches: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

