
from gurobipy import *

# Create a model
m = Model("Sandwich_Optimization")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="tuna_salad_sandwiches", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_salad_sandwiches", lb=0)

# Set the objective function
m.setObjective(2*x + 3*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 5*y <= 300, "mixing_time")
m.addConstr(5*x + 6*y <= 400, "assembling_time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of tuna salad sandwiches: {x.x}")
    print(f"Number of chicken salad sandwiches: {y.x}")
    print(f"Maximum profit: ${2*x.x + 3*y.x:.2f}")
else:
    print("No optimal solution found")
