
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x1 = model.addVar(lb=0, name="tuna_salad_sandwiches")
x2 = model.addVar(lb=0, name="chicken_salad_sandwiches")

# Define the objective function
model.setObjective(2 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(3 * x1 + 5 * x2 <= 300, name="mixing_time_constraint")
model.addConstr(5 * x1 + 6 * x2 <= 400, name="putting_together_time_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Tuna salad sandwiches: {x1.varValue}")
    print(f"Chicken salad sandwiches: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("No optimal solution found.")
