
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("CakeToppings")

# Create variables
c = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chocolate_toppings")
s = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberry_toppings")

# Set objective function
model.setObjective(2*c + 3*s, GRB.MINIMIZE)

# Add constraints
model.addConstr(1*c + 0.5*s >= 10, "sugar_constraint")
model.addConstr(2*c + 0.7*s >= 15, "butter_constraint")
model.addConstr(c <= 5, "chocolate_limit")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal}")
    print(f"Chocolate Toppings: {c.x}")
    print(f"Strawberry Toppings: {s.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

