
from gurobipy import *

# Create a new model
m = Model("Northwest_Golden_Bakery")

# Define the decision variables
x_c = m.addVar(lb=0, ub=5, vtype=GRB.INTEGER, name="chocolate_toppings")
x_s = m.addVar(lb=0, vtype=GRB.INTEGER, name="strawberry_toppings")

# Set the objective function
m.setObjective(2*x_c + 3*x_s, GRB.MINIMIZE)

# Add constraints
m.addConstr(x_c + 0.5*x_s >= 10, "sugar_constraint")
m.addConstr(2*x_c + 0.7*x_s >= 15, "butter_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate Toppings: {x_c.x}")
    print(f"Strawberry Toppings: {x_s.x}")
    print(f"Total Cost: ${2*x_c.x + 3*x_s.x}")
else:
    print("No optimal solution found")

