
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("LaundromatMix")

# Create variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="OmegaCans")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="OminiCans")

# Set objective function
model.setObjective(30*x + 40*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(3*x + 5*y >= 30, "WaterConstraint")
model.addConstr(5*x + 6*y >= 35, "DetergentConstraint")
model.addConstr(6*x + 5*y >= 40, "BleachConstraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal}")
    print(f"Omega Cans: {x.x}")
    print(f"Omini Cans: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

