
from gurobipy import *

# Create a new model
m = Model("Laundromat_Mixture")

# Define the variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="Omega_cans", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="Omini_cans", lb=0)

# Define the objective function
m.setObjective(30*x + 40*y, GRB.MINIMIZE)

# Add the constraints
m.addConstr(3*x + 5*y >= 30, "Water_constraint")
m.addConstr(5*x + 6*y >= 35, "Detergent_constraint")
m.addConstr(6*x + 5*y >= 40, "Bleach_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Minimum cost: {m.objVal}")
else:
    print("No optimal solution found")
