
import gurobi

def solve_laundromat_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(lb=0, name="Omega_cans")  # cans from Omega
    y = model.addVar(lb=0, name="Omini_cans")  # cans from Omini

    # Objective function: minimize cost
    model.setObjective(30*x + 40*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3*x + 5*y >= 30, name="water_constraint")
    model.addConstr(5*x + 6*y >= 35, name="detergent_constraint")
    model.addConstr(6*x + 5*y >= 40, name="bleach_constraint")

    # Optimize
    model.optimize()

    # Solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found")

solve_laundromat_problem()
