
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("train_seating")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="first_class")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="second_class")

# Set objective function
m.setObjective(75*x + 50*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 500, "capacity")
m.addConstr(x >= 100, "min_first_class")
m.addConstr(y >= 2*x, "second_class_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of First Class Seats: {x.x}")
    print(f"Number of Second Class Seats: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

